org 33622
		INCLUDE	"deexo.asm"
org 33792
start_load:     di
		ld 	hl, loader_table_end
load_loop:	dec	hl
		ld 	a, (hl)		; a=bank & compressed
    		and 	7		; get the BANK bits
set_ram_bank:  	ld 	b, a
               	ld 	A, ($5B5C)
               	and 	$F8
               	or 	b
               	ld 	BC, $7FFD
               	ld 	($5B5C), A      ; store the new bank in the ROM variable
               	out 	(C), A          ; and change the RAM bank
		ld 	a,(hl)		;

		dec	hl
		ld 	c, (hl)
		dec 	hl
		ld 	b, (hl)		; bc=lenght
		dec 	hl
		ld 	e, (hl)
		dec 	hl
		ld 	d, (hl)		;if compressed ->de=destination, if not compressed: de=origin
		push	hl
		pop	ix		;ix=hl
		and 	128
		jr	nz,doload
					; de==destination, hl== address of size
		push	de
		pop	ix
doload:		push 	hl
		push	af
		push 	de		; save for later
		push	ix
                call 	turboload	; call the modified ROM routine
                pop	hl
		pop 	de
		pop 	af
		call 	nz, deexo
		pop 	hl
		dec	hl
		dec	hl
		dec	hl
		jp (hl)			; go and run!

turboload      	push	ix
		add	ix,bc
		ld	a,(ix+0)
		ld	(SA_LD_RET+1),a
		pop	ix
                ld 	a, 255          ; flag (data block)
		inc	d		;This resets the zero flag (D cannot
                                       	;hold +FF)
		ex	af,af'		;The A register holds +00 for a header
					;and +FF for a block of data
		dec	d		;Restore D to its original value
                ld	a,15		;The border is made WHITE
                out	(254),a
               	ld   	hl,SA_LD_RET	;Pre-load the machine stack with the
               	push	hl		;address - SA/LD-RET
               	in	a,(254)		;Make an initial read of port 254
               	rra			;Rotate the byte obtained
               	and	32		;but keep only the EAR bit
               	or	2		;Signal RED border
               	ld	c,a		;Store the value in the C register
                                       	;(+22 for 'off' and +02 for 'on' - the
                                       	;present EAR state)
               	cp	a		;Set the zero flag

                                       	;The first stage of reading a tape involves showing that a pulsing signal
                                       	;actually exists. (i.e. 'On/off' or 'off/on' edges.)

LD_BREAK       RET  NZ                 ;Return if the BREAK key is being pressed
LD_START       CALL LD_EDGE_1          ;Return with the carry flag reset if
               JR   NC,LD_BREAK        ;there is no 'edge' within approx.
                                       ;14,000 T states. But if an 'edge' is
                                       ;found the border will go CYAN

                                       ;The next stage involves waiting a while and then showing that the signal is
                                       ;still pulsing.

               LD   HL,$0415           ;The length of this waiting period will
LD_WAIT        DJNZ LD_WAIT            ;be almost one second in duration.
               DEC  HL
               LD   A,H
               OR   L
               JR   NZ,LD_WAIT
               CALL LD_EDGE_2          ;Continue only if two edges are found
               JR   NC,LD_BREAK        ;within the allowed time period.

                                       ;Now accept only a 'leader signal'.

LD_LEADER      LD   B,$9C              ;The timing constant
               CALL LD_EDGE_2          ;Continue only if two edges are found
               JR   NC,LD_BREAK        ;within the allowed time period
               LD   A,$C6              ;However the edges must have been found
               CP   B                  ;within about 3,000 T states of each
               JR   NC,LD_START        ;other
               INC  H                  ;Count the pair of edges in the H
               JR   NZ,LD_LEADER       ;register until 256 pairs have been found

                                       ;After the leader come the 'off' and 'on' parts of the sync pulse.

LD_SYNC        LD   B,$C9              ;The timing constant
               CALL LD_EDGE_1          ;Every edge is considered until two edges
               JR   NC,LD_BREAK        ;are found close together - these will be
               LD   A,B                ;the start and finishing edges of the
               CP   $D4                ;'off' sync pulse
               JR   NC,LD_SYNC
               CALL LD_EDGE_1          ;The finishing edge of the 'on' pulse
               RET  NC                 ;must exist
                                       ;(Return carry flag reset)

                                       ;The bytes of the header or the program/data block can now be LOADed or VERIFied.
                                       ;But the first byte is the flag byte.

               LD   A,C                ;The border colours from now on will be
               XOR  3		
               LD   C,A
               LD   H,$00              ;Initialize the 'parity matching' byte
                                       ;to zero
               LD   B,$80              ;Set the timing constant for the flag
                                       ;byte.
               JR   LD_MARKER          ;Jump forward into the byte LOADing loop

                                       ;The byte LOADing loop is used to fetch the bytes one at a time. The flag byte is
                                       ;first. This is followed by the data bytes and the last byte is the 'parity'
                                       ;byte.

LD_LOOP        EX   AF,AF'             ;Fetch the flags
               JR   Z,LD_NEXT          ;Jump forward to LOAD the next byte
LD_FLAG        XOR  L                  ;Return now if the flag byte does not
               RET  NZ                 ;match the first byte on the tape
               JR   LD_DEC

LD_NEXT        LD   (IX+00),L          ;Make the actual LOAD when required
	       INC  IX                 ;Increase the 'destination'
      	       DEC  DE                 ;Decrease the 'counter'
LD_DEC         EX   AF,AF'             ;Save the flags
               LD   B,$82              ;Set the timing constant
LD_MARKER      LD   L,$01              ;Clear the 'object' register apart from
                                       ;a 'marker' bit

                                       ;The 'LD-8-BITS' loop is used to build up a byte in the L register.

LD_8_BITS      CALL LD_EDGE_2          ;Find the length of the 'off' and 'on'
                                       ;pulses of the next bit
               RET  NC                 ;Return if the time period is exceeded
                                       ;(Carry flag reset)
               LD   A,$92              ;Compare the length against approx.
               CP   B                  ;2,400 T states; resetting the carry flag
                                       ;for a '0' and setting it for a '1'
               RL   L                  ;Include the new bit in the L register
               LD   B,$80              ;Set the timing constant for the next bit
               JR   NC,LD_8_BITS       ;Jump back whilst there are still bits to
                                       ;be fetched

                                       ;The 'parity matching' byte has to be updated with each new byte.

               LD   A,H                ;Fetch the 'parity matching' byte and
               XOR  L                  ;include the new byte
               LD   H,A                ;Save it once again

                                       ;Passes round the loop are made until the 'counter' reaches zero. At that point
                                       ;the 'parity matching' byte should be holding zero.

               LD   A,D                ;Make a furter pass if the DE register
               OR   E                  ;pair does not hold zero
               JR   NZ,LD_LOOP
               LD   A,H                ;Fetch the 'parity matching' byte
               CP   $01                ;Return with the carry flag set if the
               RET                     ;value is zero (Carry flag reset if in
                                       ;error)


                                       ;THE 'LD-EDGE-2' and 'LD-EDGE-1' SUBROUTINES
                                       ;These two subroutines form the most important part of the LOAD/VERIFY operation.
                                       ;The subroutines are entered with a timing constant in the B register, and the
                                       ;previous border colour and 'edge-type' in the C register.
                                       ;The subroutines return with the carry flag set if the required number of 'edges'
                                       ;have been found in the time allowed; and the change to the value in the B
                                       ;register shows just how long it took to find the 'edge(s)'.
                                       ;The carry flag will be reset if there is an error. The zero flag then signals
                                       ;'BREAK pressed' by being reset, or 'time-up' by being set.
                                       ;The entry point LD-EDGE-2 is used when the length of a complete pulse is
                                       ;required and LD-EDGE-1 is used to find the time before the next 'edge'.

LD_EDGE_2      CALL LD_EDGE_1          ;In effect call LD-EDGE-1 twice;
               RET  NC                 ;returning in between in there is an
                                       ;error.
LD_EDGE_1      LD   A,$09              ;Wait 358 T states before entering the
LD_DELAY       DEC  A                  ;sampling loop
               JR   NZ,LD_DELAY
               AND  A

                                       ;The sampling loop is now entered. The value in the B register is incremented for
                                       ;each pass; 'time-up' is given when B reaches zero.

LD_SAMPLE      INC  B                  ;Count each pass
               RET  Z                  ;Return carry reset & zero set if
                                       ;'time-up'.
               LD   A,$7F              ;Read from port +7FFE
               IN   A,($FE)            ;i.e. BREAK and EAR
               RRA                     ;Shift the byte
               RET  NC                 ;Return carry reset & zeroreset if BREAK
                                       ;was pressed
               XOR  C                  ;Now test the byte against the 'last
               AND  $20                ;edge-type'
               JR   Z,LD_SAMPLE        ;Jump back unless it has changed

                                       ;A new 'edge' has been found within the time period allowed for the search.
                                       ;So change the border colour and set the carry flag.

		ld	a,c		;Change the 'last edge-type' and border
		add	a,3
		and	39		;Keep last edge-type and border, clear bit 3
		xor  	40	        ;Signal 'MIC off'
		ld	c,a
               	and	15		;Keep only the border colour and the MIC off
               	out	(254),a		;Change the border colour
               	scf			;Signal the successful search before
		ret			;returning
SA_LD_RET:	ld 	a,0
		ld 	(ix-1),a
		ret
loader_table:
loader_table_end:
; the loader table is composed of the following data
; number of entries (byte)
; repeat number of entries
;	 where to load (word)
;	 length (word)
;	 where to store after loading (word) 
;	 rambank/compressed (byte) -> X000YYY
;		X=1: compressed, X=0: not compressed
;		YYY: RAM Bank (0-7)
; execution address(word)
;
;	db $81		; compressed, RAM Bank 1
;	dw 6912		; bytes
;	dw 16384	; address
;	db $C3		; jmp instruction
;	dw 

;	dw 32768	; load at 32768
;	dw 5689		; load 6912 bytes
;	dw 49152	; after loading, copy to address 49152
;	db $01		; RAM Bank 1, not compressed
;
;	dw 32768	; load at 32768
;	dw 11607		; load x bytes
;	dw 49152	; after loading, copy to address 49152
;	db $03		; RAM Bank 1, not compressed
;	
;	dw 24600	; load at 24600
;	dw 11630	; load 11630 bytes
;	dw 24600	; after loading, copy to address 24600 (no copy)
;	db $00		; RAM Bank 0, not compressed
;	
;	dw 36230 	; load at 36230
;	dw 24616	; load 24616 bytes
;	dw 36230	; after loading, copy to address 36230 (no copy)
;	db $00		; RAM Bank 0, not compressed
;
;	dw 36230	; randomize usr 36230
;